package org.ow2.orchestra.pvm.internal.util;

import java.util.ArrayList;
import java.util.List;

import org.ow2.orchestra.pvm.PvmException;

/**
 * listener that only delegates events to a given listener if they pass the
 * filter based on event names.
 */
public class FilterListener implements Listener {

  protected Listener listener;
  protected List<String> eventNames;

  public FilterListener(final Listener listener, final String eventName) {
    if (listener == null) {
      throw new PvmException("listener is null");
    }
    this.listener = listener;
    if (eventName == null) {
      throw new PvmException("eventName is null");
    }
    this.eventNames = new ArrayList<String>();
    this.eventNames.add(eventName);
  }

  public FilterListener(final Listener listener, final List<String> eventNames) {
    if (listener == null) {
      throw new PvmException("listener is null");
    }
    this.listener = listener;
    if (eventNames == null) {
      throw new PvmException("eventNames is null");
    }
    this.eventNames = eventNames;
  }

  public void event(final Object source, final String name, final Object info) {
    if (!this.isFiltered(name)) {
      this.listener.event(source, name, info);
    }
  }

  public boolean isFiltered(final String eventName) {
    if (this.eventNames.contains(eventName)) {
      return false;
    }
    return true;
  }

  @Override
  public boolean equals(final Object object) {
    if (object == null) {
      return false;
    }
    if (object == this) {
      return true;
    }
    if ((object instanceof Listener) && (this.listener.equals(object))) {
      return true;
    }
    return false;
  }

  @Override
  public int hashCode() {
    return 17 + this.listener.hashCode();
  }
}
