package org.ow2.orchestra.pvm.internal.wire.binding;

import org.ow2.orchestra.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public abstract class BasicTypeBinding extends WireDescriptorBinding {

  public BasicTypeBinding(final String tagName) {
    super(tagName);
  }

  public Object parse(final Element element, final Parse parse, final Parser parser) {
    AbstractDescriptor descriptor = null;

    if (element.hasAttribute("value")) {
      final String value = element.getAttribute("value");
      descriptor = this.createDescriptor(value, element, parse);
    } else {
      parse.addProblem("attribute 'value' is required in element '"
          + XmlUtil.getTagLocalName(element) + "': "
          + XmlUtil.toString(element));
    }

    return descriptor;
  }

  public String createValueExceptionMessage(final String message, final Element element) {
    return XmlUtil.getTagLocalName(element)
        + " has invalid formatted value attribute: "
        + (message != null ? message + ": " : "") + XmlUtil.toString(element);
  }

  /**
   * subclasses can be sure that the value is not null. subclasses should use
   * {@link #createValueExceptionMessage(String, Element) for reporting format
   * problems in the parse.
   */
  protected abstract AbstractDescriptor createDescriptor(String value,
      Element element, Parse parse);
}
