package org.ow2.orchestra.pvm.internal.wire.descriptor;

import java.io.Serializable;

import org.ow2.orchestra.pvm.internal.wire.Descriptor;

/**
 * <p>
 * This class specifies an argument to be supplied to a method.
 * </p>
 *
 * @author Tom Baeyens
 * @author Guillaume Porcher (documentation)
 *
 * @see ObjectDescriptor
 * @see org.ow2.orchestra.pvm.internal.wire.operation.InvokeOperation
 * @see org.ow2.orchestra.pvm.internal.wire.operation.SubscribeOperation
 */
public class ArgDescriptor implements Serializable {

  private static final long serialVersionUID = 1L;

  protected long dbid;
  protected int dbversion;
  protected String typeName;
  protected Descriptor descriptor;

  public ArgDescriptor() {
  }

  /**
   * Gets the Descriptor used to construct the value given to the argument.
   */
  public Descriptor getDescriptor() {
    return this.descriptor;
  }

  /**
   * Sets the Descriptor used to construct the value given to the argument.
   *
   * @param descriptor
   */
  public void setDescriptor(final Descriptor descriptor) {
    this.descriptor = descriptor;
  }

  /**
   * Gets the name of the type of this argument if it is defined. If the type
   * name is not defined, the type of the Descriptor is used.
   */
  public String getTypeName() {
    return this.typeName;
  }

  /**
   * Sets the name of the type of this argument.
   *
   * @param typeName
   */
  public void setTypeName(final String typeName) {
    this.typeName = typeName;
  }
}
