package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireException;

/**
 * loads the class with the specified class name using the WireContext class
 * loader.
 *
 * @see WireContext#getClassLoader()
 *
 * @author Tom Baeyens
 * @author Guillaume Porcher (documentation)
 */
public class ClassDescriptor extends AbstractDescriptor {

  private static final long serialVersionUID = 1L;

  private String text;

  /**
   * loads the class from the class loader of the specified WireContext.
   *
   * @throws WireException
   *           if the class could not be loaded.
   */
  public Object construct(final WireContext wireContext) {
    final ClassLoader classLoader = wireContext.getClassLoader();
    try {
      return ReflectUtil.loadClass(classLoader, this.text);
    } catch (final PvmException e) {
      final Throwable cause = e.getCause();
      throw new WireException("couldn't load class '" + this.text + "': "
          + cause.getMessage(), cause);
    }
  }

  public void setClassName(final String className) {
    this.text = className;
  }

  public void setClass(final Class< ? > clazz) {
    if (clazz == null) {
      this.text = null;
    } else {
      this.text = clazz.getName();
    }
  }
}
