package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireException;

public class ContextRefDescriptor extends AbstractDescriptor implements
    Descriptor {

  private static final long serialVersionUID = 1L;

  private String contextName;

  public Object construct(final WireContext wireContext) {
    if (this.contextName == null) {
      return wireContext;
    }
    final Environment environment = Environment.getCurrent();
    if (environment == null) {
      throw new WireException("can't get context '" + this.contextName
          + "': no current environment");
    }
    return environment.getContext(this.contextName);
  }

  public String getContextName() {
    return this.contextName;
  }

  public void setContextName(final String contextName) {
    this.contextName = contextName;
  }
}
