/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.hibernate.Session;
import org.ow2.orchestra.pvm.internal.hibernate.HibernatePvmDbSession;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;
import org.ow2.orchestra.pvm.internal.wire.WireException;

/**
 * @author Tom Baeyens
 */
public class HibernatePvmDbSessionDescriptor extends AbstractDescriptor {

  private static final long serialVersionUID = 1L;

  private String sessionName;

  public Object construct(final WireContext wireContext) {
    return new HibernatePvmDbSession();
  }

  @Override
  public void initialize(final Object object, final WireContext wireContext) {
    // get the hibernate-session
    Session session = null;
    if (this.sessionName != null) {
      session = (Session) wireContext.get(this.sessionName);
    } else {
      session = wireContext.get(Session.class);
    }

    if (session == null) {
      throw new WireException("couldn't find hibernate-session "
          + (this.sessionName != null ? "'" + this.sessionName + "'" : "by type ")
          + "to create pvm-db-session");
    }

    // inject the session
    ((HibernatePvmDbSession) object).setSession(session);
  }

  @Override
  public Class< ? > getType(final WireDefinition wireDefinition) {
    return HibernatePvmDbSession.class;
  }

  public void setSessionName(final String sessionName) {
    this.sessionName = sessionName;
  }
}
