package org.ow2.orchestra.pvm.internal.wire.descriptor;

import java.util.ArrayList;

/**
 *
 * <p>
 * This {@link org.ow2.orchestra.pvm.internal.wire.Descriptor} creates a {@link java.util.List}.
 * </p>
 *
 * <p>
 * If no specific implementation for the {@link java.util.List} is specified, an
 * {@link ArrayList} will be used.
 *
 * <p>
 * Entries can be added during the list initialization. The list of entries is
 * specified with {@link #setValueDescriptors(java.util.List)}.
 * </p>
 *
 * @author Tom Baeyens
 * @author Guillaume Porcher (documentation)
 *
 * @see org.ow2.orchestra.pvm.internal.wire.Descriptor
 */
public class ListDescriptor extends CollectionDescriptor {

  private static final long serialVersionUID = 1L;

  public ListDescriptor() {
    super(ArrayList.class.getName());
  }
}
