package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;

/**
 * <p>
 * This {@link Descriptor} specifies a reference to an object. The object
 * referenced should be declared somewhere else in the wireContext.
 * </p>
 *
 * <p>
 * The constructed object is the referenced object.
 * </p>
 *
 * <p>
 * The {@link #init} field can be used to force initialization of the referenced
 * object.
 * </p>
 *
 * @author Tom Baeyens
 * @author Guillaume Porcher (documentation)
 */
public class ReferenceDescriptor extends AbstractDescriptor implements
    Descriptor {

  private static final long serialVersionUID = 1L;

  private String text = null;

  // TODO add a refExpression that is evaluated with el
  // the base referenced descriptor always should have delayedInitialization =
  // false;

  public ReferenceDescriptor() {
  }

  public ReferenceDescriptor(final String objectName) {
    this.setValue(objectName);
  }

  public Object construct(final WireContext wireContext) {
    return wireContext.get(this.text, this.isDelayedInitializationAllowed());
  }

  public boolean isDelayedInitializationAllowed() {
    return this.init == AbstractDescriptor.INIT_EAGER || this.init == AbstractDescriptor.INIT_LAZY;
  }

  public void setValue(final String objectName) {
    this.text = objectName;
  }
}
