package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;

/**
 *
 * <p>
 * This {@link Descriptor} creates a String.
 * </p>
 *
 * @author Tom Baeyens
 * @author Guillaume Porcher (documentation)
 *
 * @see Descriptor
 */
public class StringDescriptor extends AbstractDescriptor implements Descriptor {

  private static final long serialVersionUID = 1L;

  private String text;

  public StringDescriptor() {
  }

  public StringDescriptor(final String value) {
    this.setValue(value);
  }

  public StringDescriptor(final String name, final String value) {
    this.setName(name);
    this.setValue(value);
  }

  public Object construct(final WireContext factory) {
    return this.text;
  }

  public void setValue(final String value) {
    this.text = value;
  }
}
