/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.wire.xml;

import java.util.List;

import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.xml.Binding;
import org.ow2.orchestra.pvm.internal.xml.Bindings;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class BindingParser extends Parser {

  private static final Log LOG = Log.getLog(BindingParser.class.getName());

  @Override
  public Object parseDocumentElement(final Element documentElement, final Parse parse) {
    final List<Element> elements = XmlUtil.elements(documentElement, "binding");
    if (elements != null) {
      for (final Element bindingElement : elements) {
        final String bindingClassName = XmlUtil.attribute(bindingElement, "class");

        BindingParser.LOG.trace("adding wire binding for " + bindingClassName);

        Binding binding = null;
        if (bindingClassName != null) {
          try {
            final Class< ? > bindingClass = ReflectUtil.loadClass(this.classLoader,
                bindingClassName);
            binding = (Binding) bindingClass.newInstance();
          } catch (final Exception e) {
            parse.addProblem(
                "couldn't instantiate binding " + bindingClassName, e);
          }
        } else {
          parse.addProblem("class is a required attribute in a binding "
              + XmlUtil.toString(bindingElement));
        }

        if (binding != null) {
          final Bindings bindings = parse.findObject(Bindings.class);
          bindings.addBinding(binding);
        } else {
          BindingParser.LOG.info("WARNING: binding for " + bindingClassName
              + " could not be parsed. See parsing problems for more details.");
        }
      }
    }

    return null;
  }
}
