/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.processlog;

import org.ow2.orchestra.pvm.session.LogSession;

/**
 * filtering log session.
 *
 * @author Tom Baeyens
 */
public class LogSessionFilter implements LogSession {

  protected LogSession delegate;
  protected String type;

  public void add(final ProcessLog processLog) {
    if (this.passes(processLog)) {
      this.delegate.add(processLog);
    }
  }

  /**
   * can be overwritten in case filtering needs to be more sophisticated then
   * just type matching.
   */
  protected boolean passes(final ProcessLog processLog) {
    return (this.type == null) || (this.type.equals(processLog.getType()));
  }

  public void setDelegate(final LogSession delegate) {
    this.delegate = delegate;
  }

  public void setType(final String type) {
    this.type = type;
  }
}
