/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.processlog;

import java.util.Date;
import java.util.List;

import org.ow2.orchestra.pvm.Execution;

/**
 * @author Tom Baeyens
 */
public interface ProcessLog {

  long getDbid();

  Execution getExecution();

  Execution getProcessInstance();

  /**
   * text id of the type of this process log used for XML serialization.
   */
  String getType();

  /**
   * xml representation of the process log properties used for XML
   * serialization. Properties time, execution and processInstance should not be
   * included. This method is made abstract to remind and encourage implementors
   * to provide XML serialization capabilities to the fixed process log XML
   * schema. But it is allowed to return null if XML serialisation if you're
   * sure that XML serialization will never be necessary.
   */
  List<ProcessLogProperty> getProperties();

  /**
   * provides a text description for this update which can be used e.g. in the
   * admin web console. This texts hould not contain time, execution nor
   * processInstance. The default implementation will include the
   * {@link #getType() type} and then append all the top level properties.
   */
  String toString();

  Date getTime();

  void setExecution(Execution execution);

  void setTime(Date currentTime);
}
