/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.session;

import java.util.List;

import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.client.ClientExecution;
import org.ow2.orchestra.pvm.client.ClientProcessDefinition;
import org.ow2.orchestra.pvm.job.Job;
import org.ow2.orchestra.pvm.job.Message;
import org.ow2.orchestra.pvm.job.Timer;

/**
 * @author Tom Baeyens, Pascal Verdage
 */
public interface PvmDbSession extends DbSession {

  /** all deployed process names. */
  List<String> findProcessDefinitionNames();

  /** all versions of the given process. */
  List<ClientProcessDefinition> findProcessDefinitionsByName(String name);

  /** specific version of a named processDefinition. */
  ClientProcessDefinition findProcessDefinitionByName(String name, int version);

  /** latest version of the processDefinition with the given name. */
  ClientProcessDefinition findLatestProcessDefinitionByName(String name);

  /**
   * the process definition uniquely identified by the given processDefinition
   * id.
   */
  ClientProcessDefinition findProcessDefinitionById(String processDefinitionId);

  /** the execution uniquely identified by the given executionKey. */
  ClientExecution findExecutionById(String executionId);

  /**
   * the execution uniquely identified by the given processDefinition name and
   * the execution key.
   */
  Execution findExecutionByKey(String processDefinitionName, String executionKey);

  /** timers */
  List<Timer> findTimers(int firstResult, int maxResults);

  /** timers */
  List<Message> findMessages(int firstResult, int maxResults);

  /**
   * the jobs for which all the retries have failed and which will not be picked
   * up any more by the jobImpl executor
   */
  List<Job> findJobsWithException();
}
