/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.deploy;

import org.ow2.orchestra.pvm.Deployment;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;

/**
 * @author Tom Baeyens
 */
public class CreateId implements Deployer {

  private static final Log LOG = Log.getLog(CreateId.class.getName());

  public void deploy(Deployment deployment) {
    ProcessDefinitionImpl processDefinition = (ProcessDefinitionImpl) deployment
        .getProcessDefinition();

    if (processDefinition.getId() == null) {
      String key = processDefinition.getKey();
      if (key == null) {
        key = processDefinition.getName();
      }

      if ("".equals(key)) {
        throw new PvmException("empty string is not a valid key");
      }

      // replace any non-word character with an underscore
      key = key.replaceAll("\\W", "_");

      String id = key + ":" + processDefinition.getVersion();

      LOG.trace("created id '" + id + "' for " + processDefinition);
      processDefinition.setId(id);
    }
  }
}
