/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.ejb;

import java.util.Date;

import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.job.TimerImpl;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.session.DbSession;

/**
 * @author Tom Baeyens
 * @author Alejandro Guizar
 */
public class ExecuteTimerCmd implements Command<Date> {

  private final long timerDbid;

  private static final long serialVersionUID = 1L;
  private static final Log LOG = Log.getLog(ExecuteTimerCmd.class.getName());

  public ExecuteTimerCmd(final long timerDbid) {
    this.timerDbid = timerDbid;
  }

  public Date execute(final Environment environment) {
    final DbSession dbSession = environment.get(DbSession.class);
    final TimerImpl timerImpl = dbSession.get(TimerImpl.class, this.timerDbid);
    if (timerImpl == null) {
      ExecuteTimerCmd.LOG.debug("timer not found: " + this.timerDbid);
      return null; // i.e. delete this timer
    }
    return timerImpl.execute(environment) ? null : timerImpl.getDueDate();
  }

  @Override
  public String toString() {
    return ExecuteTimerCmd.class.getSimpleName() + '(' + this.timerDbid + ')';
  }
}
