/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.log;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author Tom Baeyens
 */
public class Log {

  public static Log getLog(final String name) {
    return new Log(Logger.getLogger(name));
  }

  private final Logger log;

  public Log(final Logger logger) {
    this.log = logger;
  }

  public void error(final String msg) {
    this.log.log(Level.SEVERE, msg);
  }

  public void error(final String msg, final Throwable exception) {
    this.log.log(Level.SEVERE, msg, exception);
  }

  public void warn(final String msg) {
    this.log.log(Level.WARNING, msg);
  }

  public void warn(final String msg, final Throwable exception) {
    this.log.log(Level.WARNING, msg, exception);
  }

  public boolean isInfoEnabled() {
    return this.log.isLoggable(Level.INFO);
  }

  public void info(final String msg) {
    this.log.log(Level.INFO, msg);
  }

  public void info(final String msg, final Throwable exception) {
    this.log.log(Level.INFO, msg, exception);
  }

  public boolean isDebugEnabled() {
    return this.log.isLoggable(Level.FINE);
  }

  public void debug(final String msg) {
    this.log.log(Level.FINE, msg);
  }

  public void debug(final String msg, final Throwable exception) {
    this.log.log(Level.FINE, msg, exception);
  }

  public boolean isTraceEnabled() {
    return this.log.isLoggable(Level.FINEST);
  }

  public void trace(final String msg) {
    this.log.log(Level.FINEST, msg);
  }

  public void trace(final String msg, final Throwable exception) {
    this.log.log(Level.FINEST, msg, exception);
  }
}
