/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.spring;

import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.env.SpringEnvironmentFactory;
import org.ow2.orchestra.pvm.internal.env.BasicEnvironment;
import org.springframework.context.ApplicationContext;

/**
 * sees the prototype beans in the application context and this environment will
 * cache all the prototyped objects.
 * 
 * @author Tom Baeyens
 */
public class SpringEnvironment extends BasicEnvironment {

  private static final long serialVersionUID = 1L;

  protected ApplicationContext applicationContext;

  public SpringEnvironment(SpringEnvironmentFactory springEnvironmentFactory) {
    addContext(springEnvironmentFactory);
    addContext(new SpringEnvironmentContext(springEnvironmentFactory
        .getApplicationContext()));
  }

  public void close() {
  }

  public ClassLoader getClassLoader() {
    return null;
  }

  public EnvironmentFactory getEnvironmentFactory() {
    return null;
  }

  public Throwable getException() {
    return null;
  }

  public String getUserId() {
    return null;
  }

  public void setClassLoader(ClassLoader classLoader) {
  }

  public void setException(Throwable exception) {
  }

  public void setUserId(String userId) {
  }
}
