/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.svc;

import java.util.List;

import org.ow2.orchestra.pvm.Deployment;
import org.ow2.orchestra.pvm.ProcessDefinition;
import org.ow2.orchestra.pvm.ProcessService;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.cmd.DeployCmd;
import org.ow2.orchestra.pvm.internal.cmd.FindLatestProcessDefinitionCmd;
import org.ow2.orchestra.pvm.internal.cmd.FindProcessDefinitionCmd;
import org.ow2.orchestra.pvm.internal.cmd.FindProcessDefinitionNamesCmd;
import org.ow2.orchestra.pvm.internal.cmd.FindProcessDefinitionsCmd;
import org.ow2.orchestra.pvm.model.OpenProcessDefinition;

/**
 * {@link ProcessService} implementation that delegates execution of the methods
 * to a {@link CommandService}.
 * 
 * @author Tom Baeyens
 */
public class CommandProcessService implements ProcessService {

  protected CommandService commandService;

  public ProcessDefinition deploy(OpenProcessDefinition processDefinition) {
    Deployment deployment = new Deployment(processDefinition);
    return commandService.execute(new DeployCmd(deployment));
  }

  public ProcessDefinition deploy(Deployment deployment) {
    return commandService.execute(new DeployCmd(deployment));
  }

  public ProcessDefinition findLatestProcessDefinition(
      String processDefinitionName) {
    return commandService.execute(new FindLatestProcessDefinitionCmd(
        processDefinitionName));
  }

  public ProcessDefinition findProcessDefinition(String processDefinitionName,
      int version) {
    return commandService.execute(new FindProcessDefinitionCmd(
        processDefinitionName, version));
  }

  public List<String> findProcessDefinitionNames() {
    return commandService.execute(new FindProcessDefinitionNamesCmd());
  }

  public List<ProcessDefinition> findProcessDefinitions(
      String processDefinitionName) {
    return (List) commandService.execute(new FindProcessDefinitionsCmd(
        processDefinitionName));
  }

  public CommandService getCommandService() {
    return commandService;
  }

  public void setCommandService(CommandService commandService) {
    this.commandService = commandService;
  }
}
