/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.type.variable;

import org.ow2.orchestra.pvm.internal.lob.Blob;
import org.ow2.orchestra.pvm.internal.type.Variable;

public class BlobVariable extends Variable {

  private static final long serialVersionUID = 1L;

  protected Blob blob = null;

  public boolean isStorable(Object value) {
    if (value == null) {
      return true;
    }
    return byte[].class.isAssignableFrom(value.getClass());
  }

  public Object getObject() {
    if (blob == null) {
      return null;
    }
    return blob.extractBytes();
  }

  public void setObject(Object value) {
    this.blob = new Blob((byte[]) value);
  }

  public Blob getBlob() {
    return blob;
  }
}
