/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.ow2.orchestra.pvm.internal.deploy.Deployer;
import org.ow2.orchestra.pvm.internal.deploy.DeployerManager;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;

/**
 * @author Tom Baeyens
 */
public class DeployerManagerDescriptor extends AbstractDescriptor {

  private static final long serialVersionUID = 1L;

  /** maps extensions to language-ids */
  protected Map<String, String> extensions = new HashMap<String, String>();

  /** maps language-ids to a sequence of process deployers */
  protected Map<String, List<Descriptor>> deployerDescriptors = new HashMap<String, List<Descriptor>>();

  public Object construct(final WireContext wireContext) {
    return new DeployerManager();
  }

  @Override
  public void initialize(final Object object, final WireContext wireContext) {
    final DeployerManager deployerManager = (DeployerManager) object;

    final Map<String, List<Deployer>> deployers = new HashMap<String, List<Deployer>>();
    for (final Map.Entry<String, List<Descriptor>> languageEntry : this.deployerDescriptors
        .entrySet()) {
      final String language = languageEntry.getKey();
      final List<Descriptor> descriptors = languageEntry.getValue();

      final List<Deployer> deployerSequence = new ArrayList<Deployer>();
      for (final Descriptor descriptor : descriptors) {
        deployerSequence.add((Deployer) wireContext.create(descriptor, true));
      }

      deployers.put(language, deployerSequence);
    }

    deployerManager.setExtensions(this.extensions);
    deployerManager.setDeployers(deployers);
  }

  @Override
  public Class< ? > getType(final WireDefinition wireDefinition) {
    return DeployerManager.class;
  }

  public void addLanguage(final String language, final String extension,
      final List<Descriptor> deployerDescriptorSequence) {
    if (extension != null) {
      this.extensions.put(extension, language);
    }
    this.deployerDescriptors.put(language, deployerDescriptorSequence);
  }
}
