package org.ow2.orchestra.pvm.internal.wire.operation;

import java.lang.reflect.Field;

import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireException;

/**
 * injects another object into a field.
 *
 * @author Tom Baeyens
 * @author Guillaume Porcher (documentation)
 *
 */
public class FieldOperation extends AbstractOperation {

  private static final long serialVersionUID = 1L;

  private String fieldName = null;
  private Descriptor descriptor = null;

  private transient Field field = null;

  public FieldOperation() {
  }

  public void apply(final Object target, final WireContext wireContext) {
    if (target != null) {

      // Get field
      synchronized (this) {
        if (this.field == null) {
          final Class< ? > clazz = target.getClass();
          this.field = ReflectUtil.getField(clazz, this.fieldName);
        }
      }

      // Create value
      final Object value = wireContext.create(this.descriptor, true);
      // Set the field value
      try {
        ReflectUtil.set(this.field, target, value);
      } catch (final Exception e) {
        throw new WireException("couldn't set " + this.fieldName + " to " + value, e);
      }
    }
  }

  /**
   * Gets the name of the field that should be updated by this operation.
   */
  public String getFieldName() {
    return this.fieldName;
  }

  /**
   * Sets the name of the field that should be updated by this operation.
   *
   * @param fieldName
   */
  public void setFieldName(final String fieldName) {
    this.fieldName = fieldName;
  }

  /**
   * Gets the descriptor used to create the field's value.
   */
  public Descriptor getDescriptor() {
    return this.descriptor;
  }

  /**
   * Sets the descriptor used to create the field's value
   *
   * @param valueDescriptor
   */
  public void setDescriptor(final Descriptor valueDescriptor) {
    this.descriptor = valueDescriptor;
  }

}
