/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.pvm.session.DbSession;
import org.ow2.orchestra.pvm.session.MessageSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsMessageSession
implements MessageSession {
    private static final long serialVersionUID = 1L;
    protected DbSession dbSession;
    protected Session jmsSession;
    protected Destination jmsDestination;

    @Override
    public void send(MessageImpl<?> message) {
        try {
            this.dbSession.save(message);
            Message jmsMessage = this.jmsSession.createMessage();
            MessageProducer messageProducer = this.jmsSession.createProducer(this.jmsDestination);
            try {
                messageProducer.send(jmsMessage);
            }
            catch (Exception e) {
                throw new PvmException("couldn't send jms message: " + e.getMessage(), e);
            }
            finally {
                messageProducer.close();
            }
            jmsMessage.setLongProperty("jobId", message.getDbid());
        }
        catch (JMSException e) {
            throw new PvmException("couldn't send jms message", e);
        }
    }

    public void close() {
    }
}

