/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.hibernate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.hibernate.type.ImmutableType;
import org.hibernate.usertype.ParameterizedType;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.type.Converter;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;

/**
 * @author Tom Baeyens
 */
public class ConverterType extends ImmutableType implements ParameterizedType {

  private static final long serialVersionUID = 1L;
  private Map<Class< ? >, String> converterNames = null;
  private Map<String, Converter> converters = null;

  @Override
  public Object fromStringValue(final String arg0) {
    return null;
  }

  @Override
  public Object get(final ResultSet resultSet, final String name) throws SQLException {
    final String converterName = resultSet.getString(name);
    return this.converters.get(converterName);
  }

  @Override
  public void set(final PreparedStatement stmt, final Object value, final int index) throws SQLException {
    final String converterName = value != null ? this.converterNames.get(value.getClass()) : null;
    stmt.setString(index, converterName);
  }

  @Override
  public int sqlType() {
    return Types.VARCHAR;
  }

  @Override
  public String toString(final Object arg0) {
    return null;
  }

  public String getName() {
    return "converter";
  }

  public Class< ? > getReturnedClass() {
    return Converter.class;
  }

  public void setParameterValues(final Properties properties) {
    this.converterNames = new HashMap<Class< ? >, String>();
    this.converters = new HashMap<String, Converter>();

    for (final Object key : properties.keySet()) {
      final String converterClassName = (String) key;
      try {
        final ClassLoader classLoader = Thread.currentThread()
            .getContextClassLoader();
        final Class< ? > converterClass = ReflectUtil.loadClass(classLoader,
            converterClassName);

        final String converterName = properties.getProperty(converterClassName);
        this.converterNames.put(converterClass, converterName);
        final Converter converter = (Converter) converterClass.newInstance();
        this.converters.put(converterName, converter);
      } catch (final Exception e) {
        throw new PvmException("couldn't initialize converter type "
            + converterClassName, e);
      }
    }
  }
}
