package org.ow2.orchestra.pvm.internal.jobexecutor;

import java.util.Collection;
import java.util.List;

import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.session.DbSession;

/**
 * internal interface used by the jobImpl executor and the implementations of
 * {@link org.ow2.orchestra.pvm.session.MessageSession} and {@link org.ow2.orchestra.pvm.session.TimerSession}.
 *
 * So this session is only needed in case the {@link JobExecutor} is used to
 * execute messages or timers.
 *
 * @author Tom Baeyens, Pascal Verdage
 */
public interface JobDbSession extends DbSession {

  /** the jobImpl with the given id or null if none */
  JobImpl< ? > getJob(long jobId);

  /**
   * the first jobImpl to finish among eligible and non-locked jobs or null if
   * none
   */
  Collection<JobImpl< ? >> findFirstAcquirableJob(int limit, boolean limitSameInstanceJobs);

  /** the list of jobs of the process instance that mustn't be concurrent */
  List<JobImpl< ? >> findExclusiveJobs(Execution processInstance);

  /** the first jobImpl to finish among non-owned jobs or null if none */
  JobImpl< ? > findFirstDueJob();
}
