/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.stream;

import java.io.InputStream;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;

/**
 * @author Tom Baeyens
 */
public class ResourceStreamSource extends StreamSource {

  protected ClassLoader classLoader;
  protected String resource;

  /**
   * @throws PvmException
   *           if resource is null
   */
  public ResourceStreamSource(String resource) {
    this(resource, null);
  }

  /**
   * @throws PvmException
   *           if resource is null
   */
  public ResourceStreamSource(String resource, ClassLoader classLoader) {
    if (resource == null) {
      throw new PvmException("resource is null");
    }
    this.name = "resource://" + resource;
    this.resource = resource;
    this.classLoader = classLoader;
  }

  public InputStream openStream() {
    InputStream stream = ReflectUtil.getResourceAsStream(classLoader, resource);
    if (stream == null) {
      throw new PvmException("resource " + resource + " does not exist");
    }
    return stream;
  }
}
