/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.svc;

import java.util.List;

import org.ow2.orchestra.pvm.ManagementService;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.cmd.GetMessagesCmd;
import org.ow2.orchestra.pvm.internal.cmd.GetTimersCmd;
import org.ow2.orchestra.pvm.job.Job;
import org.ow2.orchestra.pvm.job.Message;
import org.ow2.orchestra.pvm.job.Timer;

/**
 * @author Tom Baeyens
 */
public class CommandManagementService implements ManagementService {

  protected CommandService commandService;

  public void executeJob(String jobId) {
    // TODO
  }

  public List<Job> getJobsWithException(int firstResult, int maxResults) {
    // TODO
    return null;
  }

  public List<Message> getMessages(int firstResult, int maxResults) {
    return commandService.execute(new GetMessagesCmd(firstResult, maxResults));
  }

  public List<Timer> getTimers(int firstResult, int maxResults) {
    return commandService.execute(new GetTimersCmd(firstResult, maxResults));
  }

}
