/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.util;

public abstract class EqualsUtil {

  private EqualsUtil() { }

  public static boolean equals(final Object thisObject, final Object otherObject) {
    if ((thisObject == null) || (otherObject == null)) {
      return false;
    }

    if (EqualsUtil.isProxy(otherObject)) {
      return otherObject.equals(thisObject);
    } else {
      return otherObject == thisObject;
    }
  }

  private static boolean isInitialized = false;
  private static boolean isHibernateInClasspth = true;
  private static Class< ? > hibernateProxyClass = null;

  private static boolean isProxy(final Object otherObject) {
    final boolean isProxy = false;
    if (!EqualsUtil.isInitialized) {
      EqualsUtil.initializeHibernateProxyClass();
    }

    if (EqualsUtil.isHibernateInClasspth) {
      return EqualsUtil.hibernateProxyClass.isAssignableFrom(otherObject.getClass());
    }
    return isProxy;
  }

  private static synchronized void initializeHibernateProxyClass() {
    try {
      final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
      EqualsUtil.hibernateProxyClass = classLoader
          .loadClass("org.hibernate.proxy.HibernateProxy");
    } catch (final ClassNotFoundException e) {
      EqualsUtil.isHibernateInClasspth = false;
    }
    EqualsUtil.isInitialized = true;
  }
}
