/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.hibernate.StaleStateException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.LockAcquisitionException;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.svc.RetryInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDispatcherThread
extends Thread {
    private boolean isActive = true;
    private boolean checkForNewJobs;
    private final Object semaphore = new Object();
    private static final Log LOG = Log.getLog(AbstractDispatcherThread.class.getName());

    public AbstractDispatcherThread() {
    }

    public AbstractDispatcherThread(Runnable target) {
        super(target);
    }

    public AbstractDispatcherThread(String name) {
        super(name);
    }

    public AbstractDispatcherThread(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    protected abstract void putAcquiredJobDbidsOnQueue(Collection<JobImpl<?>> var1);

    public AbstractDispatcherThread(ThreadGroup group, String name) {
        super(group, name);
    }

    public AbstractDispatcherThread(Runnable target, String name) {
        super(target, name);
    }

    public AbstractDispatcherThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public AbstractDispatcherThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            LOG.info("starting...");
            long delay = 50L;
            int delayFactor = 2;
            CommandService commandService = this.getJobExecutor().getCommandExecutor();
            if (commandService instanceof RetryInterceptor) {
                delay = ((RetryInterceptor)commandService).getDelay();
                delayFactor = ((RetryInterceptor)commandService).getDelayFactor();
            }
            long currentDelay = delay;
            block14: while (true) {
                while (this.isActive) {
                    Object jobs;
                    try {
                        long waitPeriod;
                        this.checkForNewJobs = false;
                        Collection<Collection<JobImpl<?>>> acquiredJobDbids = this.acquireJobs();
                        currentDelay = delay;
                        if (acquiredJobDbids != null && !acquiredJobDbids.isEmpty()) {
                            Iterator<Collection<JobImpl<?>>> i$ = acquiredJobDbids.iterator();
                            while (true) {
                                if (!i$.hasNext()) continue block14;
                                jobs = i$.next();
                                this.putAcquiredJobDbidsOnQueue((Collection<JobImpl<?>>)jobs);
                                LOG.info("added jobs " + jobs + " to the queue");
                            }
                        }
                        if (!this.isActive || (waitPeriod = this.getWaitPeriod()) <= 0L) continue block14;
                        Object object = this.semaphore;
                        synchronized (object) {
                            if (!this.checkForNewJobs) {
                                LOG.debug(this.getName() + " will wait for max " + waitPeriod + "ms on " + this.getJobExecutor());
                                this.semaphore.wait(waitPeriod);
                                LOG.debug(this.getName() + " woke up");
                            } else {
                                LOG.debug("skipped wait because new message arrived");
                            }
                            continue block14;
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info((this.isActive ? "active" : "inactivated") + " jobImpl dispatcher thread '" + this.getName() + "' got interrupted");
                    }
                    catch (Exception e) {
                        String logMessage = "exception in job executor dispatcher thread. Waiting " + currentDelay + " milliseconds";
                        if (e instanceof StaleStateException || e instanceof LockAcquisitionException || e instanceof GenericJDBCException) {
                            LOG.trace(logMessage, e);
                        } else {
                            LOG.error(logMessage, e);
                        }
                        try {
                            jobs = this.semaphore;
                            synchronized (jobs) {
                                this.semaphore.wait(currentDelay);
                            }
                        }
                        catch (InterruptedException e2) {
                            LOG.trace("delay after exception got interrupted", e2);
                        }
                        currentDelay *= (long)delayFactor;
                    }
                }
                break block24;
                {
                    continue block14;
                    break;
                }
                break;
            }
            finally {
                LOG.info(this.getName() + " leaves cyberspace");
            }
        }
    }

    protected Collection<Collection<JobImpl<?>>> acquireJobs() {
        CommandService commandService = this.getJobExecutor().getCommandExecutor();
        Command<Collection<Collection<JobImpl<?>>>> acquireJobsCommand = this.getJobExecutor().getAcquireJobsCommand();
        return commandService.execute(acquireJobsCommand);
    }

    protected Date getNextDueDate() {
        CommandService commandService = this.getJobExecutor().getCommandExecutor();
        Command<Date> getNextDueDate = this.getJobExecutor().getNextDueDateCommand();
        return commandService.execute(getNextDueDate);
    }

    protected long getWaitPeriod() {
        long interval = this.getJobExecutor().getIdleMillis();
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTimeMillis = System.currentTimeMillis();
            long nextDueDateTime = nextDueDate.getTime();
            if (nextDueDateTime < currentTimeMillis + interval) {
                interval = nextDueDateTime - currentTimeMillis;
            }
        }
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean join) {
        if (this.isActive) {
            LOG.debug("deactivating " + this.getName());
            this.isActive = false;
            this.interrupt();
            if (join) {
                while (this.isAlive()) {
                    try {
                        LOG.debug("joining " + this.getName());
                        this.join();
                    }
                    catch (InterruptedException e) {
                        LOG.trace("joining " + this.getName() + " got interrupted");
                    }
                }
            }
        } else {
            LOG.trace("ignoring deactivate: " + this.getName() + " is not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        LOG.trace("notifying jobImpl executor dispatcher thread of new jobImpl");
        Object object = this.semaphore;
        synchronized (object) {
            this.checkForNewJobs = true;
            this.semaphore.notify();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public abstract AbstractJobExecutor getJobExecutor();
}

