/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.env;

import java.util.Collections;
import java.util.Set;

import org.ow2.orchestra.pvm.env.Context;
import org.ow2.orchestra.pvm.internal.job.JobImpl;

public class JobContext implements Context {

  public static final String KEY = "jobImpl";

  private final JobImpl< ? > jobImpl;

  public JobContext(final JobImpl< ? > job) {
    this.jobImpl = job;
  }

  public Object get(final String key) {
    if (JobContext.KEY.equals(key)) {
      return this.jobImpl;
    }
    return null;
  }

  public boolean has(final String key) {
    return JobContext.KEY.equals(key);
  }

  public Set<String> keys() {
    return Collections.singleton(JobContext.KEY);
  }

  public Object set(final String key, final Object value) {
    throw new UnsupportedOperationException("set is not supported on "
        + JobContext.class.getName());
  }

  public <T> T get(final Class<T> type) {
    return null;
  }

  public String getName() {
    return null;
  }
}
