package org.ow2.orchestra.pvm.internal.util;

public abstract class ArrayUtil {

  private ArrayUtil() { }

  public static String toString(final Object[] array) {
    if (array == null) {
      return "null";
    } else {
      final StringBuffer buffer = new StringBuffer();
      buffer.append("[");
      for (int i = 0; i < array.length; i++) {
        final Object o = array[i];
        if (o != null) {
          buffer.append(o);
        } else {
          buffer.append("null");
        }
        if (i != array.length - 1) {
          buffer.append("|");
        }
      }
      buffer.append("]");
      return buffer.toString();
    }
  }
}
