/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.xml;

import java.io.Serializable;

import org.xml.sax.SAXParseException;

/**
 * a unification for an XML parsing errors and DOM interpretation problems, see
 * also {@link Parser}.
 *
 * See also <a href="./Parser.html#problems">'Problems'</a>
 *
 * @author Tom Baeyens
 */
public class Problem implements Serializable {

  private static final long serialVersionUID = 1L;

  public static final String SEVERITY_WARNING = "warning";
  public static final String SEVERITY_ERROR = "error";
  public static final String SEVERITY_FATALERROR = "fatal-error";

  private String resource;
  private String severity;
  private Integer line = -1;
  private Integer column = -1;
  private String msg;
  private Throwable cause;

  public Problem(final String msg, final Exception e, final String severity) {
    this.severity = severity;
    this.msg = msg;
    this.cause = e;
    if (e instanceof SAXParseException) {
      final SAXParseException spe = (SAXParseException) e;
      this.resource = spe.getPublicId();
      this.line = spe.getLineNumber();
      this.column = spe.getColumnNumber();
    }
  }

  public Throwable getCause() {
    return this.cause;
  }

  public void setCause(final Throwable cause) {
    this.cause = cause;
  }

  public int getColumn() {
    return this.column;
  }

  public void setColumn(final int columnNumber) {
    this.column = columnNumber;
  }

  public int getLine() {
    return this.line;
  }

  public void setLine(final int lineNumber) {
    this.line = lineNumber;
  }

  public String getMsg() {
    return this.msg;
  }

  public void setMsg(final String msg) {
    this.msg = msg;
  }

  public String getResource() {
    return this.resource;
  }

  public void setResource(final String resource) {
    this.resource = resource;
  }

  public String getSeverity() {
    return this.severity;
  }

  public void setSeverity(final String severity) {
    this.severity = severity;
  }

  @Override
  public String toString() {
    final StringBuffer text = new StringBuffer();
    text.append(this.severity);
    text.append(" : ");
    text.append(this.msg);
    text.append(" ");

    if ((this.line != -1) || (this.column != -1) || (this.resource != null)) {
      text.append("[");
      if (this.line != -1) {
        text.append("line=" + this.line + " ");
      }

      if (this.column != -1) {
        text.append("column=" + this.column + " ");
      }

      if (this.resource != null) {
        text.append("resource=" + this.resource + " ");
      }
      text.append("]");
    }

    if (this.cause != null) {
      text.append(": " + this.cause.toString());
    }

    return text.toString();
  }
}
