/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.client.ClientExecution;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.session.PvmDbSession;

/**
 * @author Tom Baeyens
 */
public class GetVariablesCmd implements Command<Map<String, Object>> {

  private static final long serialVersionUID = 1L;

  protected String executionId;
  protected List<String> variableNames;

  public GetVariablesCmd(final String executionId, final List<String> variableNames) {
    if (executionId == null) {
      throw new PvmException("executionId is null");
    }
    this.executionId = executionId;
    if (variableNames == null) {
      throw new PvmException("variableNames is null");
    }
    this.variableNames = variableNames;
  }

  public Map<String, Object> execute(final Environment environment) {
    final PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);

    final ClientExecution execution = pvmDbSession.findExecutionById(this.executionId);

    final Map<String, Object> variables = new HashMap<String, Object>();
    for (final String variableName : this.variableNames) {
      final Object value = execution.getVariable(variableName);
      variables.put(variableName, value);
    }

    return variables;
  }
}
