/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.spring;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.ow2.orchestra.pvm.env.Context;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.springframework.context.ApplicationContext;

/**
 * @author Tom Baeyens
 */
public class SpringEnvironmentContext implements Context {

  // TODO pull up the common behaviour between this class and the
  // SpringEnvironmentFactory

  private ApplicationContext applicationContext;
  private final Map<String, Object> cache = new HashMap<String, Object>();

  public SpringEnvironmentContext(final ApplicationContext applicationContext) {
    this.applicationContext = applicationContext;
  }

  public boolean has(final String key) {
    return this.applicationContext.isPrototype(key);
  }

  public Object get(final String key) {
    if (this.cache.containsKey(key)) {
      return this.cache.get(key);
    }
    if (this.has(key)) {
      final Object bean = this.applicationContext.getBean(key);
      // cache.put(key, bean);
      return bean;
    }
    return null;
  }

  public <T> T get(final Class<T> type) {
    String name = ReflectUtil.getUnqualifiedClassName(type);
    name = name.substring(0, 1).toLowerCase() + name.substring(1);
    return (T) this.get(name);
  }

  public Set<String> keys() {
    final HashSet<String> keys = new HashSet<String>();
    for (final String key : this.applicationContext.getBeanDefinitionNames()) {
      if (this.has(key)) {
        keys.add(key);
      }
    }
    return keys;
  }

  public ApplicationContext getApplicationContext() {
    return this.applicationContext;
  }

  public void setApplicationContext(final ApplicationContext applicationContext) {
    this.applicationContext = applicationContext;
  }

  public String getName() {
    return null;
  }

  public Object set(final String key, final Object value) {
    return null;
  }
}
