package org.ow2.orchestra.pvm.internal.wire.descriptor;

import java.util.HashSet;

/**
 *
 * <p>
 * This {@link org.ow2.orchestra.pvm.internal.wire.Descriptor} creates a {@link java.util.Set}.
 * </p>
 *
 * <p>
 * If no specific implementation for the {@link java.util.Set} is specified, a
 * {@link HashSet} will be used.
 *
 * <p>
 * Entries can be added during the set initialization. The list of entries is
 * specified with {@link #setValueDescriptors(java.util.List)}.
 * </p>
 *
 * @author Tom Baeyens
 * @author Guillaume Porcher (documentation)
 *
 * @see org.ow2.orchestra.pvm.internal.wire.Descriptor
 */
public class SetDescriptor extends CollectionDescriptor {

  private static final long serialVersionUID = 1L;

  public SetDescriptor() {
    super(HashSet.class.getName());
  }
}
