/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.env;

import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.env.PvmEnvironmentFactory;
import org.ow2.orchestra.pvm.internal.stream.StreamSource;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;
import org.ow2.orchestra.pvm.internal.wire.xml.WireParser;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PvmEnvironmentFactoryParser
extends Parser {
    private static final long serialVersionUID = 1L;
    private WireParser environmentFactoryXmlParser = new WireParser();
    private WireParser environmentXmlParser = new WireParser();
    private static final PvmEnvironmentFactoryParser INSTANCE = new PvmEnvironmentFactoryParser();

    public static PvmEnvironmentFactoryParser getInstance() {
        return INSTANCE;
    }

    static EnvironmentFactory parse(StreamSource streamSource) {
        EnvironmentFactory environmentFactory = (EnvironmentFactory)PvmEnvironmentFactoryParser.getInstance().createParse().setStreamSource(streamSource).execute().checkProblems("environment configuration " + streamSource).getDocumentObject();
        return environmentFactory;
    }

    public Object parseDocument(Document document, Parse parse) {
        Element documentElement = document.getDocumentElement();
        PvmEnvironmentFactory pvmEnvironmentFactory = (PvmEnvironmentFactory)parse.getDocumentObject();
        if (pvmEnvironmentFactory == null) {
            pvmEnvironmentFactory = new PvmEnvironmentFactory();
            parse.setDocumentObject(pvmEnvironmentFactory);
        }
        WireDefinition environmentFactoryWireDefinition = this.getApplicationWireDefinition(documentElement, parse);
        WireDefinition environmentWireDefinition = this.getBlockWireDefinition(documentElement, parse);
        WireContext environmentFactoryWireContext = new WireContext(environmentFactoryWireDefinition, "environment-factory");
        environmentFactoryWireContext.setClassLoader(this.classLoader);
        pvmEnvironmentFactory.setEnvironmentFactoryCtxWireContext(environmentFactoryWireContext);
        pvmEnvironmentFactory.setEnvironmentCtxWireDefinition(environmentWireDefinition);
        parse.setDocumentObject(pvmEnvironmentFactory);
        return pvmEnvironmentFactory;
    }

    WireDefinition getApplicationWireDefinition(Element documentElement, Parse parse) {
        Element applicationElement = XmlUtil.element((Element)documentElement, (String)"environment-factory");
        if (applicationElement != null) {
            return (WireDefinition)this.environmentFactoryXmlParser.parseDocumentElement(applicationElement, parse);
        }
        return null;
    }

    WireDefinition getBlockWireDefinition(Element documentElement, Parse parse) {
        Element blockElement = XmlUtil.element((Element)documentElement, (String)"environment");
        if (blockElement != null) {
            return (WireDefinition)this.environmentXmlParser.parseDocumentElement(blockElement, parse);
        }
        return null;
    }

    public WireParser getEnvironmentFactoryXmlParser() {
        return this.environmentFactoryXmlParser;
    }

    public void setEnvironmentFactoryXmlParser(WireParser applicationWireXmlParser) {
        this.environmentFactoryXmlParser = applicationWireXmlParser;
    }

    public WireParser getEnvironmentXmlParser() {
        return this.environmentXmlParser;
    }

    public void setEnvironmentXmlParser(WireParser blockWireXmlParser) {
        this.environmentXmlParser = blockWireXmlParser;
    }
}

