/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import java.util.Date;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.job.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteJobCmd
implements Command<Job> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(ExecuteJobCmd.class.getName());
    protected JobImpl<?> jobDbid;

    public ExecuteJobCmd(JobImpl<?> jobDbid) {
        this.jobDbid = jobDbid;
    }

    @Override
    public Job execute(Environment environment) {
        JobDbSession session = environment.get(JobDbSession.class);
        if (session == null) {
            throw new PvmException("no job session configured to get job " + this.jobDbid + " for execution");
        }
        int oldVersion = this.jobDbid.getDbversion();
        JobImpl job = session.get(JobImpl.class, this.jobDbid.getDbid());
        if (job == null) {
            LOG.debug("job " + this.jobDbid + " no longer exists");
            return null;
        }
        if (oldVersion != job.getDbversion()) {
            LOG.debug("job " + this.jobDbid + " updated externally");
            return job;
        }
        LOG.debug("executing job " + job + "...");
        job.execute(environment);
        LOG.debug("executed job " + job);
        Date lockExpirationDate = job.getLockExpirationTime();
        if (lockExpirationDate != null) {
            long lockExpiration = lockExpirationDate.getTime();
            long currentTime = System.currentTimeMillis();
            if (currentTime > lockExpiration) {
                throw new PvmException("job took too long: lock expired " + (currentTime - lockExpiration) + "ms ago");
            }
        }
        return job;
    }
}

