/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.model.CompositeElementImpl;
import org.ow2.orchestra.pvm.internal.model.ExceptionHandlerSynchronization;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ObjectReference;
import org.ow2.orchestra.pvm.internal.model.ProcessElementImpl;
import org.ow2.orchestra.pvm.internal.model.TransitionImpl;
import org.ow2.orchestra.pvm.internal.model.op.MoveToChildNode;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.listener.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Log LOG = Log.getLog(ExceptionHandlerImpl.class.getName());
    protected long dbid;
    protected int dbversion;
    protected String exceptionClassName;
    protected boolean isTransactional = false;
    protected boolean isRethrowMasked = false;
    protected List<ObjectReference<EventListener>> eventListenerReferences;
    protected String transitionName;
    protected String nodeName;

    public ObjectReference<EventListener> createEventListenerReference(EventListener eventListener) {
        ObjectReference<EventListener> eventListenerReference = this.createEventListenerReference();
        eventListenerReference.set(eventListener);
        return eventListenerReference;
    }

    public ObjectReference<EventListener> createEventListenerReference(Descriptor descriptor) {
        ObjectReference<EventListener> eventListenerReference = this.createEventListenerReference();
        eventListenerReference.setDescriptor(descriptor);
        return eventListenerReference;
    }

    public ObjectReference<EventListener> createActivityReference(String expression) {
        ObjectReference<EventListener> eventListenerReference = this.createEventListenerReference();
        eventListenerReference.setExpression(expression);
        return eventListenerReference;
    }

    public ObjectReference<EventListener> createEventListenerReference() {
        if (this.eventListenerReferences == null) {
            this.eventListenerReferences = new ArrayList<ObjectReference<EventListener>>();
        }
        ObjectReference<EventListener> actionObjectReference = new ObjectReference<EventListener>();
        this.eventListenerReferences.add(actionObjectReference);
        return actionObjectReference;
    }

    public List<EventListener> getEventListeners() {
        if (this.eventListenerReferences == null) {
            return null;
        }
        ArrayList<EventListener> eventListeners = new ArrayList<EventListener>(this.eventListenerReferences.size());
        for (ObjectReference<EventListener> eventListenerReference : this.eventListenerReferences) {
            EventListener eventListener = eventListenerReference.get();
            eventListeners.add(eventListener);
        }
        return eventListeners;
    }

    public boolean matches(Exception exception) {
        return this.matches(exception.getClass());
    }

    public boolean matches(Class<?> exceptionClass) {
        if (exceptionClass == null) {
            return false;
        }
        Class<?> exceptionClassClass = ReflectUtil.loadClass(Thread.currentThread().getContextClassLoader(), this.exceptionClassName);
        return exceptionClassClass.isAssignableFrom(exceptionClass);
    }

    public void handle(ExecutionImpl execution, Exception exception, ProcessElementImpl processElementImpl) {
        if (this.isTransactional) {
            Transaction transaction;
            Environment environment = Environment.getCurrent();
            Transaction transaction2 = transaction = environment != null ? environment.get(Transaction.class) : null;
            if (transaction != null) {
                LOG.trace("registering exception handler to " + transaction);
                CommandService commandService = environment.get(CommandService.class);
                if (commandService == null) {
                    throw new PvmException("environment doesn't have a command service for registering transactional exception handler", exception);
                }
                ExceptionHandlerSynchronization exceptionHandlerSynchronization = new ExceptionHandlerSynchronization(this, execution, exception, processElementImpl, commandService);
                exceptionHandlerSynchronization.register(transaction);
                LOG.trace("registering exception handler to " + transaction);
                throw new PvmException("transaction exception handler registered handler after transaction completed.  make sure this transaction is rolled back", exception);
            }
            throw new PvmException("no transaction present in the environment for transactional exception handler", exception);
        }
        this.executeHandler(execution, exception, processElementImpl);
    }

    protected void executeHandler(ExecutionImpl execution, Exception exception, ProcessElementImpl processElementImpl) {
        if (this.eventListenerReferences != null) {
            for (ObjectReference<EventListener> eventListenerReference : this.eventListenerReferences) {
                EventListener eventListener = eventListenerReference.get();
                LOG.trace("executing " + eventListener + " for " + this);
                try {
                    eventListener.notify(execution);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PvmException("couldn't execute " + eventListener, e);
                }
            }
        }
        if (this.transitionName != null || this.nodeName != null) {
            execution.setPropagation(ExecutionImpl.Propagation.EXPLICIT);
        }
        if (this.transitionName != null) {
            NodeImpl node = null;
            if (processElementImpl != null && processElementImpl instanceof NodeImpl) {
                node = (NodeImpl)processElementImpl;
                TransitionImpl transition = node.findOutgoingTransition(this.transitionName);
                if (transition != null) {
                    LOG.trace(this.toString() + " takes transition " + this.transitionName);
                    execution.take(transition);
                } else {
                    LOG.info("WARNING: " + this.toString() + " couldn't find transition " + this.transitionName + " on " + node);
                }
            } else {
                LOG.info("WARNING: " + this.toString() + " couldn't find current node to take transition " + this.transitionName);
            }
        } else if (this.nodeName != null) {
            NodeImpl childNode = null;
            if (processElementImpl != null && processElementImpl instanceof CompositeElementImpl) {
                childNode = ((CompositeElementImpl)processElementImpl).getNode(this.nodeName);
            }
            if (childNode != null) {
                LOG.trace(this.toString() + " executes node " + this.nodeName);
                execution.performAtomicOperationSync(new MoveToChildNode(childNode));
            } else {
                LOG.info("WARNING: " + this.toString() + " couldn't find child node " + this.nodeName);
            }
        }
    }

    public static void rethrow(Exception exception, String prefixMessage) {
        LOG.trace("rethrowing " + exception);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new PvmException(prefixMessage + ": " + exception.getMessage(), exception);
    }

    public String toString() {
        return this.exceptionClassName != null ? "exception-handler(" + this.exceptionClassName + ")" : "exception-handler";
    }

    public long getDbid() {
        return this.dbid;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void setTransactional(boolean isTransactional) {
        this.isTransactional = isTransactional;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public boolean isRethrowMasked() {
        return this.isRethrowMasked;
    }

    public void setRethrowMasked(boolean isRethrowMasked) {
        this.isRethrowMasked = isRethrowMasked;
    }

    public List<ObjectReference<EventListener>> getEventListenerReferences() {
        return this.eventListenerReferences;
    }

    public void setEventListenerReferences(List<ObjectReference<EventListener>> activityReferences) {
        this.eventListenerReferences = activityReferences;
    }
}

