/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.pvm.internal.util.PvmXmlUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.binding.AbstractCollectionBinding;
import org.ow2.orchestra.pvm.internal.wire.binding.WireDescriptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.MapDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MapBinding
extends WireDescriptorBinding {
    public MapBinding() {
        super("map");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        Boolean isSynchronized;
        MapDescriptor descriptor = new MapDescriptor();
        String className = XmlUtil.attribute((Element)element, (String)"class");
        if (AbstractCollectionBinding.verify(className, Map.class, parse, parser)) {
            descriptor.setClassName(className);
        }
        if ((isSynchronized = PvmXmlUtil.attributeBoolean(element, "synchronized", false, parse)) != null) {
            descriptor.setSynchronized(isSynchronized);
        }
        ArrayList<Descriptor> keyDescriptors = new ArrayList<Descriptor>();
        ArrayList<Descriptor> valueDescriptors = new ArrayList<Descriptor>();
        List elements = XmlUtil.elements((Element)element);
        if (elements != null) {
            for (Element entryElement : elements) {
                if ("entry".equals(XmlUtil.getTagLocalName((Element)entryElement))) {
                    Element keyElement = XmlUtil.element((Element)entryElement, (String)"key");
                    Element keyDescriptorElement = keyElement != null ? XmlUtil.element((Element)keyElement) : null;
                    Descriptor keyDescriptor = (Descriptor)parser.parseElement(keyDescriptorElement, parse, "descriptor");
                    Element valueElement = XmlUtil.element((Element)entryElement, (String)"value");
                    Element valueDescriptorElement = valueElement != null ? XmlUtil.element((Element)valueElement) : null;
                    Descriptor valueDescriptor = (Descriptor)parser.parseElement(valueDescriptorElement, parse, "descriptor");
                    if (keyDescriptor != null && valueDescriptor != null) {
                        keyDescriptors.add(keyDescriptor);
                        valueDescriptors.add(valueDescriptor);
                        continue;
                    }
                    parse.addProblem("entry must have key and value element with a single descriptor as contents: " + XmlUtil.toString((Node)entryElement));
                    continue;
                }
                parse.addProblem("map can only contain entry elements: " + XmlUtil.toString((Node)entryElement));
            }
        }
        descriptor.setKeyDescriptors(keyDescriptors);
        descriptor.setValueDescriptors(valueDescriptors);
        return descriptor;
    }
}

