/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.rest.client;

import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.ow2.orchestra.facade.InstanceManagementAPI;
import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.data.runtime.PendingMessageData;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.JobNotFoundException;
import org.ow2.orchestra.facade.rest.JaxRSInstanceManagementAPI;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.util.JAXBUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author Guillaume Porcher
 */
public class JaxRSInstanceManagementAPIClient implements InstanceManagementAPI {

  private final JaxRSInstanceManagementAPI proxy;

  public JaxRSInstanceManagementAPIClient(String orchestraURL) {
    JAXBElementProvider provider = new JAXBElementProvider();
    provider.setCollectionWrapperName("collection");
    provider.setSingleJaxbContext(true);
    provider.setExtraClass(JAXBUtils.JAXB_CLASSES);
    this.proxy = JAXRSClientFactory.create(orchestraURL, JaxRSInstanceManagementAPI.class, Arrays.asList(provider));
  }

  public void exit(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
    this.proxy.exit(processInstanceUUID);
  }

  public void resume(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
    this.proxy.resume(processInstanceUUID);
  }

  public void suspend(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
    this.proxy.suspend(processInstanceUUID);
  }

  public boolean remove(ProcessInstanceUUID processInstanceUUID) {
    return this.proxy.remove(processInstanceUUID);
  }

  public List<JobData> findJobsWithException() {
    return this.proxy.findJobsWithException().getContentAsList();
  }

  public void retryJob(JobData job, int retries) throws JobNotFoundException {
    this.proxy.retryJob(job, retries);
  }

  public List<PendingMessageData> getPendingMessages() {
    return this.proxy.getPendingMessages().getContentAsList();
  }

  public void removePendingMessage(PendingMessageData message) {
    this.proxy.removePendingMessage(message);
  }
}
