/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.rest.client;

import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.ow2.orchestra.facade.QueryDefinitionAPI;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.ActivityNotFoundException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.rest.JaxRSQueryDefinitionAPI;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.util.JAXBUtils;

import javax.xml.namespace.QName;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * @author Guillaume Porcher
 */
public class JaxRSQueryDefinitionAPIClient implements QueryDefinitionAPI {
  private final JaxRSQueryDefinitionAPI proxy;

  public JaxRSQueryDefinitionAPIClient(String orchestraURL) {
    JAXBElementProvider provider = new JAXBElementProvider();
    provider.setCollectionWrapperName("collection");
    provider.setSingleJaxbContext(true);
    provider.setExtraClass(JAXBUtils.JAXB_CLASSES);
    this.proxy = JAXRSClientFactory.create(orchestraURL, JaxRSQueryDefinitionAPI.class, Arrays.asList(provider));
  }

  public List<ProcessDefinition> findProcessDefinitions() {
    return this.proxy.findProcessDefinitions(null, null, null).getContentAsList();
  }

  public List<ProcessDefinition> findProcessDefinitions(ProcessState state) {
    return this.proxy.findProcessDefinitions(null, null, state).getContentAsList();
  }

  public List<ProcessDefinition> findProcessDefinitions(QName processQName, ProcessState state) {
    return this.proxy.findProcessDefinitions(processQName.getNamespaceURI(), processQName.getLocalPart(), state).getContentAsList();
  }

  public List<ProcessDefinition> findProcessDefinitions(QName processQName) {
    return this.proxy.findProcessDefinitions(processQName.getNamespaceURI(), processQName.getLocalPart(), null).getContentAsList();
  }

  public ProcessDefinition getProcessDefinition(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
    return this.proxy.getProcessDefinition(processUUID).getContent();
  }

  public ActivityDefinition getActivityDefinition(ActivityDefinitionUUID activityDefinitionUUID) throws ActivityNotFoundException {
    return this.proxy.getActivityDefinition(activityDefinitionUUID).getContent();
  }

  public Set<ActivityDefinition> findActivityDefinitions(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
    return this.proxy.findActivityDefinitions(processUUID).getContentAsSet();
  }

  public byte[] getProcessResource(ProcessDefinitionUUID processUUID, String resourceName) throws ProcessNotFoundException {
    return this.proxy.getProcessResource(processUUID, resourceName).getContent();
  }
}
