/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.rest.client;

import java.util.Arrays;
import java.util.List;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.ow2.orchestra.facade.InstanceManagementAPI;
import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.data.runtime.PendingMessageData;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.JobNotFoundException;
import org.ow2.orchestra.facade.rest.JaxRSInstanceManagementAPI;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.util.JAXBUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRSInstanceManagementAPIClient
implements InstanceManagementAPI {
    private final JaxRSInstanceManagementAPI proxy;

    public JaxRSInstanceManagementAPIClient(String orchestraURL) {
        JAXBElementProvider provider = new JAXBElementProvider();
        provider.setCollectionWrapperName("collection");
        provider.setSingleJaxbContext(true);
        provider.setExtraClass(JAXBUtils.JAXB_CLASSES);
        this.proxy = JAXRSClientFactory.create(orchestraURL, JaxRSInstanceManagementAPI.class, Arrays.asList(provider));
    }

    @Override
    public void exit(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        this.proxy.exit(processInstanceUUID);
    }

    @Override
    public void resume(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        this.proxy.resume(processInstanceUUID);
    }

    @Override
    public void suspend(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        this.proxy.suspend(processInstanceUUID);
    }

    @Override
    public boolean remove(ProcessInstanceUUID processInstanceUUID) {
        return this.proxy.remove(processInstanceUUID);
    }

    @Override
    public List<JobData> findJobsWithException() {
        return this.proxy.findJobsWithException().getContentAsList();
    }

    @Override
    public void retryJob(JobData job, int retries) throws JobNotFoundException {
        this.proxy.retryJob(job, retries);
    }

    @Override
    public List<PendingMessageData> getPendingMessages() {
        return this.proxy.getPendingMessages().getContentAsList();
    }

    @Override
    public void removePendingMessage(PendingMessageData message) {
        this.proxy.removePendingMessage(message);
    }
}

