/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionManagerImpl;
import org.apache.cxf.bus.spring.OldSpringSupport;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.springframework.beans.Mergeable;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanLocator
implements ConfiguredBeanLocator {
    ApplicationContext context;
    ConfiguredBeanLocator orig;
    Set<String> passThroughs = new HashSet<String>();

    public SpringBeanLocator(ApplicationContext ctx, Bus bus) {
        this.context = ctx;
        this.orig = bus.getExtension(ConfiguredBeanLocator.class);
        if (this.orig instanceof ExtensionManagerImpl) {
            ArrayList<String> names = new ArrayList<String>();
            for (String s : ctx.getBeanDefinitionNames()) {
                ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)this.context;
                BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(s);
                String cn = def.getBeanClassName();
                if (OldSpringSupport.class.getName().equals(cn)) {
                    this.passThroughs.add(s);
                    for (String s2 : ctx.getAliases(s)) {
                        this.passThroughs.add(s2);
                    }
                    continue;
                }
                names.add(s);
                for (String s2 : ctx.getAliases(s)) {
                    names.add(s2);
                }
            }
            ((ExtensionManagerImpl)this.orig).removeBeansOfNames(names);
        }
    }

    @Override
    public List<String> getBeanNamesOfType(Class<?> type) {
        LinkedHashSet<String> s = new LinkedHashSet<String>(Arrays.asList(this.context.getBeanNamesForType(type, false, true)));
        s.removeAll(this.passThroughs);
        s.addAll(this.orig.getBeanNamesOfType(type));
        return new ArrayList<String>(s);
    }

    @Override
    public <T> Collection<? extends T> getBeansOfType(Class<T> type) {
        LinkedHashSet<String> s = new LinkedHashSet<String>(Arrays.asList(this.context.getBeanNamesForType(type, false, true)));
        s.removeAll(this.passThroughs);
        LinkedList<T> lst = new LinkedList<T>();
        for (String n : s) {
            lst.add(this.context.getBean(n, type));
        }
        lst.addAll(this.orig.getBeansOfType(type));
        return lst;
    }

    @Override
    public <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.context.getBeanNamesForType(type, false, true)));
        list.removeAll(this.passThroughs);
        Collections.reverse(list);
        boolean loaded = false;
        for (String s : list) {
            Class<?> beanType;
            Class<T> t;
            if (!listener.loadBean(s, t = (beanType = this.context.getType(s)).asSubclass(type))) continue;
            Object o = this.context.getBean(s);
            if (listener.beanLoaded(s, type.cast(o))) {
                return true;
            }
            loaded = true;
        }
        return loaded || this.orig.loadBeansOfType(type, listener);
    }

    @Override
    public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String searchValue) {
        if (this.context.containsBean(beanName) && !this.passThroughs.contains(beanName)) {
            ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)this.context;
            BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(beanName);
            if (!ctxt.getBeanFactory().isSingleton(beanName) || def.isAbstract()) {
                return false;
            }
            Collection ids = null;
            PropertyValue pv = def.getPropertyValues().getPropertyValue(propertyName);
            if (pv != null) {
                Object value = pv.getValue();
                if (!(value instanceof Collection)) {
                    throw new RuntimeException("The property " + propertyName + " must be a collection!");
                }
                if (value instanceof Mergeable) {
                    if (!((Mergeable)value).isMergeEnabled()) {
                        ids = (Collection)value;
                    }
                } else {
                    ids = (Collection)value;
                }
            }
            if (ids != null) {
                for (Object o : ids) {
                    if (!(o instanceof TypedStringValue ? searchValue.equals(((TypedStringValue)o).getValue()) : searchValue.equals((String)o))) continue;
                    return true;
                }
            }
        }
        return this.orig.hasConfiguredPropertyValue(beanName, propertyName, searchValue);
    }
}

