/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormUtils {
    public static final String FORM_PARAM_MAP = "org.apache.cxf.form_data";
    private static final String MULTIPART_FORM_DATA_TYPE = "form-data";

    private FormUtils() {
    }

    public static void addPropertyToForm(MultivaluedMap<String, String> map, String name, Object value) {
        if (!"".equals(name)) {
            map.add(name, value.toString());
        } else {
            MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(value, "");
            for (Map.Entry entry : values.entrySet()) {
                for (Object v : (List)entry.getValue()) {
                    map.add((String)entry.getKey(), v.toString());
                }
            }
        }
    }

    public static String readBody(InputStream is, MediaType mt) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy(is, bos, 1024);
            return new String(bos.toByteArray(), HttpUtils.getEncoding(mt, "UTF-8"));
        }
        catch (Exception ex) {
            throw new WebApplicationException(ex);
        }
    }

    public static void populateMapFromString(MultivaluedMap<String, String> params, String postBody, boolean decode, HttpServletRequest request) {
        block5: {
            block4: {
                if (StringUtils.isEmpty(postBody)) break block4;
                List<String> parts = Arrays.asList(postBody.split("&"));
                for (String part : parts) {
                    String[] keyValue = part.split("=");
                    String name = HttpUtils.urlDecode(keyValue[0]);
                    if (keyValue.length == 2) {
                        if (decode) {
                            params.add(name, HttpUtils.urlDecode(keyValue[1]));
                            continue;
                        }
                        params.add(name, keyValue[1]);
                        continue;
                    }
                    params.add(name, "");
                }
                break block5;
            }
            if (request == null) break block5;
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String paramName = en.nextElement().toString();
                String[] values = request.getParameterValues(paramName);
                params.put(HttpUtils.urlDecode(paramName), (String)((Object)Arrays.asList(values)));
            }
        }
    }

    public static void populateMapFromMultipart(MultivaluedMap<String, String> params, MultipartBody body, boolean decode) {
        List<Attachment> atts = body.getAllAttachments();
        for (Attachment a : atts) {
            ContentDisposition cd = a.getContentDisposition();
            if (cd == null || !MULTIPART_FORM_DATA_TYPE.equalsIgnoreCase(cd.getType()) || cd.getParameter("name") == null) {
                throw new WebApplicationException(415);
            }
            String name = cd.getParameter("name").replace("\"", "").replace("'", "");
            try {
                String value = IOUtils.toString(a.getDataHandler().getInputStream());
                params.add(HttpUtils.urlDecode(name), decode ? HttpUtils.urlDecode(value) : value);
            }
            catch (IOException ex) {
                throw new WebApplicationException(415);
            }
        }
    }
}

