/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.rest.client;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.ow2.orchestra.facade.QueryDefinitionAPI;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.ActivityNotFoundException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.rest.JaxRSQueryDefinitionAPI;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.util.JAXBUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRSQueryDefinitionAPIClient
implements QueryDefinitionAPI {
    private final JaxRSQueryDefinitionAPI proxy;

    public JaxRSQueryDefinitionAPIClient(String orchestraURL) {
        JAXBElementProvider provider = new JAXBElementProvider();
        provider.setCollectionWrapperName("collection");
        provider.setSingleJaxbContext(true);
        provider.setExtraClass(JAXBUtils.JAXB_CLASSES);
        this.proxy = JAXRSClientFactory.create(orchestraURL, JaxRSQueryDefinitionAPI.class, Arrays.asList(provider));
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions() {
        return this.proxy.findProcessDefinitions(null, null, null).getContentAsList();
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(ProcessState state) {
        return this.proxy.findProcessDefinitions(null, null, state).getContentAsList();
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processQName, ProcessState state) {
        return this.proxy.findProcessDefinitions(processQName.getNamespaceURI(), processQName.getLocalPart(), state).getContentAsList();
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processQName) {
        return this.proxy.findProcessDefinitions(processQName.getNamespaceURI(), processQName.getLocalPart(), null).getContentAsList();
    }

    @Override
    public ProcessDefinition getProcessDefinition(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        return this.proxy.getProcessDefinition(processUUID).getContent();
    }

    @Override
    public ActivityDefinition getActivityDefinition(ActivityDefinitionUUID activityDefinitionUUID) throws ActivityNotFoundException {
        return this.proxy.getActivityDefinition(activityDefinitionUUID).getContent();
    }

    @Override
    public Set<ActivityDefinition> findActivityDefinitions(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        return this.proxy.findActivityDefinitions(processUUID).getContentAsSet();
    }

    @Override
    public byte[] getProcessResource(ProcessDefinitionUUID processUUID, String resourceName) throws ProcessNotFoundException {
        return this.proxy.getProcessResource(processUUID, resourceName).getContent();
    }
}

