/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.rest.client;

import java.util.Arrays;
import java.util.Set;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.ow2.orchestra.facade.QueryRuntimeAPI;
import org.ow2.orchestra.facade.criteria.Criteria;
import org.ow2.orchestra.facade.criteria.PagedResult;
import org.ow2.orchestra.facade.exception.ActivityInstanceNotFoundException;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.rest.JaxRSQueryRuntimeAPI;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.util.JAXBUtils;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRSQueryRuntimeAPIClient
implements QueryRuntimeAPI {
    private final JaxRSQueryRuntimeAPI proxy;

    public JaxRSQueryRuntimeAPIClient(String orchestraURL) {
        JAXBElementProvider provider = new JAXBElementProvider();
        provider.setCollectionWrapperName("collection");
        provider.setSingleJaxbContext(true);
        provider.setExtraClass(JAXBUtils.JAXB_CLASSES);
        this.proxy = JAXRSClientFactory.create(orchestraURL, JaxRSQueryRuntimeAPI.class, Arrays.asList(provider));
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID) throws InstanceNotFoundException {
        return this.proxy.findActivityInstances(processUUID, null).getContentAsSet();
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID, ActivityState activityState) throws InstanceNotFoundException {
        return this.proxy.findActivityInstances(processUUID, activityState).getContentAsSet();
    }

    @Override
    public Set<ProcessInstance> findProcessInstances() {
        try {
            return this.proxy.findProcessInstances(null, null).getContentAsSet();
        }
        catch (ProcessNotFoundException e) {
            Misc.unreachableStatement();
            return null;
        }
    }

    @Override
    public PagedResult<ProcessInstance> findProcessInstancesPage(Criteria<ProcessInstance> criteria) {
        return this.proxy.findProcessInstancesPage(criteria);
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        return this.proxy.findProcessInstances(processDefinitionUUID, null).getContentAsSet();
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) throws ProcessNotFoundException {
        return this.proxy.findProcessInstances(processDefinitionUUID, processInstanceState).getContentAsSet();
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ActivityState processInstanceState) {
        try {
            return this.proxy.findProcessInstances(null, processInstanceState).getContentAsSet();
        }
        catch (ProcessNotFoundException e) {
            Misc.unreachableStatement();
            return null;
        }
    }

    @Override
    public ProcessInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        return this.proxy.getProcessInstance(processInstanceUUID).getContent();
    }

    @Override
    public ActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) throws ActivityInstanceNotFoundException {
        return this.proxy.getActivityInstance(activityInstanceUUID).getContent();
    }
}

