/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDataBinder
extends DataBinder {
    public static final String DEFAULT_FIELD_MARKER_PREFIX = "_";
    public static final String DEFAULT_FIELD_DEFAULT_PREFIX = "!";
    private String fieldMarkerPrefix = "_";
    private String fieldDefaultPrefix = "!";
    private boolean bindEmptyMultipartFiles = true;

    public WebDataBinder(Object target) {
        super(target);
    }

    public WebDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    public String getFieldMarkerPrefix() {
        return this.fieldMarkerPrefix;
    }

    public void setFieldDefaultPrefix(String fieldDefaultPrefix) {
        this.fieldDefaultPrefix = fieldDefaultPrefix;
    }

    public String getFieldDefaultPrefix() {
        return this.fieldDefaultPrefix;
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public boolean isBindEmptyMultipartFiles() {
        return this.bindEmptyMultipartFiles;
    }

    @Override
    protected void doBind(MutablePropertyValues mpvs) {
        this.checkFieldDefaults(mpvs);
        this.checkFieldMarkers(mpvs);
        super.doBind(mpvs);
    }

    protected void checkFieldDefaults(MutablePropertyValues mpvs) {
        if (this.getFieldDefaultPrefix() != null) {
            PropertyValue[] pvArray;
            String fieldDefaultPrefix = this.getFieldDefaultPrefix();
            PropertyValue[] propertyValueArray = pvArray = mpvs.getPropertyValues();
            int n = pvArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyValue pv = propertyValueArray[n2];
                if (pv.getName().startsWith(fieldDefaultPrefix)) {
                    String field = pv.getName().substring(fieldDefaultPrefix.length());
                    if (this.getPropertyAccessor().isWritableProperty(field) && !mpvs.contains(field)) {
                        mpvs.add(field, pv.getValue());
                    }
                    mpvs.removePropertyValue(pv);
                }
                ++n2;
            }
        }
    }

    protected void checkFieldMarkers(MutablePropertyValues mpvs) {
        if (this.getFieldMarkerPrefix() != null) {
            PropertyValue[] pvArray;
            String fieldMarkerPrefix = this.getFieldMarkerPrefix();
            PropertyValue[] propertyValueArray = pvArray = mpvs.getPropertyValues();
            int n = pvArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyValue pv = propertyValueArray[n2];
                if (pv.getName().startsWith(fieldMarkerPrefix)) {
                    String field = pv.getName().substring(fieldMarkerPrefix.length());
                    if (this.getPropertyAccessor().isWritableProperty(field) && !mpvs.contains(field)) {
                        Class fieldType = this.getPropertyAccessor().getPropertyType(field);
                        mpvs.add(field, this.getEmptyValue(field, fieldType));
                    }
                    mpvs.removePropertyValue(pv);
                }
                ++n2;
            }
        }
    }

    protected Object getEmptyValue(String field, Class fieldType) {
        if (fieldType != null && Boolean.TYPE.equals(fieldType) || Boolean.class.equals((Object)fieldType)) {
            return Boolean.FALSE;
        }
        if (fieldType != null && fieldType.isArray()) {
            return Array.newInstance(fieldType.getComponentType(), 0);
        }
        return null;
    }

    @Deprecated
    protected void bindMultipartFiles(Map<String, MultipartFile> multipartFiles, MutablePropertyValues mpvs) {
        for (Map.Entry<String, MultipartFile> entry : multipartFiles.entrySet()) {
            String key = entry.getKey();
            MultipartFile value = entry.getValue();
            if (!this.isBindEmptyMultipartFiles() && value.isEmpty()) continue;
            mpvs.add(key, value);
        }
    }

    protected void bindMultipart(Map<String, List<MultipartFile>> multipartFiles, MutablePropertyValues mpvs) {
        for (Map.Entry<String, List<MultipartFile>> entry : multipartFiles.entrySet()) {
            String key = entry.getKey();
            List<MultipartFile> values = entry.getValue();
            if (values.size() == 1) {
                MultipartFile value = values.get(0);
                if (!this.isBindEmptyMultipartFiles() && value.isEmpty()) continue;
                mpvs.add(key, value);
                continue;
            }
            mpvs.add(key, values);
        }
    }
}

