/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.support.ServletContextScope;

public abstract class WebApplicationContextUtils {
    private static final boolean jsfPresent = ClassUtils.isPresent("javax.faces.context.FacesContext", RequestContextHolder.class.getClassLoader());

    public static WebApplicationContext getRequiredWebApplicationContext(ServletContext sc) throws IllegalStateException {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(sc);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    public static WebApplicationContext getWebApplicationContext(ServletContext sc) {
        return WebApplicationContextUtils.getWebApplicationContext(sc, WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public static WebApplicationContext getWebApplicationContext(ServletContext sc, String attrName) {
        Assert.notNull(sc, "ServletContext must not be null");
        Object attr = sc.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        if (attr instanceof RuntimeException) {
            throw (RuntimeException)attr;
        }
        if (attr instanceof Error) {
            throw (Error)attr;
        }
        if (attr instanceof Exception) {
            throw new IllegalStateException((Exception)attr);
        }
        if (!(attr instanceof WebApplicationContext)) {
            throw new IllegalStateException("Context attribute is not of type WebApplicationContext: " + attr);
        }
        return (WebApplicationContext)attr;
    }

    public static void registerWebApplicationScopes(ConfigurableListableBeanFactory beanFactory) {
        WebApplicationContextUtils.registerWebApplicationScopes(beanFactory, null);
    }

    public static void registerWebApplicationScopes(ConfigurableListableBeanFactory beanFactory, ServletContext sc) {
        beanFactory.registerScope("request", new RequestScope());
        beanFactory.registerScope("session", new SessionScope(false));
        beanFactory.registerScope("globalSession", new SessionScope(true));
        if (sc != null) {
            ServletContextScope appScope = new ServletContextScope(sc);
            beanFactory.registerScope("application", appScope);
            sc.setAttribute(ServletContextScope.class.getName(), (Object)appScope);
        }
        beanFactory.registerResolvableDependency(ServletRequest.class, new RequestObjectFactory());
        beanFactory.registerResolvableDependency(HttpSession.class, new SessionObjectFactory());
        beanFactory.registerResolvableDependency(WebRequest.class, new WebRequestObjectFactory());
        if (jsfPresent) {
            FacesDependencyRegistrar.registerFacesDependencies(beanFactory);
        }
    }

    public static void registerEnvironmentBeans(ConfigurableListableBeanFactory bf, ServletContext sc) {
        WebApplicationContextUtils.registerEnvironmentBeans(bf, sc, null);
    }

    public static void registerEnvironmentBeans(ConfigurableListableBeanFactory bf, ServletContext sc, ServletConfig config) {
        if (sc != null && !bf.containsBean("servletContext")) {
            bf.registerSingleton("servletContext", sc);
        }
        if (config != null && !bf.containsBean("servletConfig")) {
            bf.registerSingleton("servletConfig", config);
        }
        if (!bf.containsBean("contextParameters")) {
            String paramName;
            Enumeration paramNameEnum;
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            if (sc != null) {
                paramNameEnum = sc.getInitParameterNames();
                while (paramNameEnum.hasMoreElements()) {
                    paramName = (String)paramNameEnum.nextElement();
                    parameterMap.put(paramName, sc.getInitParameter(paramName));
                }
            }
            if (config != null) {
                paramNameEnum = config.getInitParameterNames();
                while (paramNameEnum.hasMoreElements()) {
                    paramName = (String)paramNameEnum.nextElement();
                    parameterMap.put(paramName, config.getInitParameter(paramName));
                }
            }
            bf.registerSingleton("contextParameters", Collections.unmodifiableMap(parameterMap));
        }
        if (!bf.containsBean("contextAttributes")) {
            HashMap<String, Object> attributeMap = new HashMap<String, Object>();
            if (sc != null) {
                Enumeration attrNameEnum = sc.getAttributeNames();
                while (attrNameEnum.hasMoreElements()) {
                    String attrName = (String)attrNameEnum.nextElement();
                    attributeMap.put(attrName, sc.getAttribute(attrName));
                }
            }
            bf.registerSingleton("contextAttributes", Collections.unmodifiableMap(attributeMap));
        }
    }

    private static ServletRequestAttributes currentRequestAttributes() {
        RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
        if (!(requestAttr instanceof ServletRequestAttributes)) {
            throw new IllegalStateException("Current request is not a servlet request");
        }
        return (ServletRequestAttributes)requestAttr;
    }

    private static class FacesDependencyRegistrar {
        private FacesDependencyRegistrar() {
        }

        public static void registerFacesDependencies(ConfigurableListableBeanFactory beanFactory) {
            beanFactory.registerResolvableDependency(FacesContext.class, new ObjectFactory<FacesContext>(){

                @Override
                public FacesContext getObject() {
                    return FacesContext.getCurrentInstance();
                }

                public String toString() {
                    return "Current JSF FacesContext";
                }
            });
            beanFactory.registerResolvableDependency(ExternalContext.class, new ObjectFactory<ExternalContext>(){

                @Override
                public ExternalContext getObject() {
                    return FacesContext.getCurrentInstance().getExternalContext();
                }

                public String toString() {
                    return "Current JSF ExternalContext";
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestObjectFactory
    implements ObjectFactory<ServletRequest>,
    Serializable {
        private RequestObjectFactory() {
        }

        @Override
        public ServletRequest getObject() {
            return WebApplicationContextUtils.currentRequestAttributes().getRequest();
        }

        public String toString() {
            return "Current HttpServletRequest";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SessionObjectFactory
    implements ObjectFactory<HttpSession>,
    Serializable {
        private SessionObjectFactory() {
        }

        @Override
        public HttpSession getObject() {
            return WebApplicationContextUtils.currentRequestAttributes().getRequest().getSession();
        }

        public String toString() {
            return "Current HttpSession";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WebRequestObjectFactory
    implements ObjectFactory<WebRequest>,
    Serializable {
        private WebRequestObjectFactory() {
        }

        @Override
        public WebRequest getObject() {
            return new ServletWebRequest(WebApplicationContextUtils.currentRequestAttributes().getRequest());
        }

        public String toString() {
            return "Current ServletWebRequest";
        }
    }
}

