/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.rest.client;

import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.ManagementAPI;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.rest.ByteArrayWrapper;
import org.ow2.orchestra.facade.rest.JaxRSManagementAPI;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.util.JAXBUtils;

/**
 * @author Guillaume Porcher
 */
public class JaxRSManagementAPIClient implements ManagementAPI {

  private final JaxRSManagementAPI proxy;

  public JaxRSManagementAPIClient(String orchestraURL) {
    JAXBElementProvider provider = new JAXBElementProvider();
    provider.setCollectionWrapperName("collection");
    provider.setSingleJaxbContext(true);
    provider.setExtraClass(JAXBUtils.JAXB_CLASSES);
    this.proxy = JAXRSClientFactory.create(orchestraURL, JaxRSManagementAPI.class, Arrays.asList(provider));
  }

  public ProcessDefinition deployBar(byte[] barFile) {
    return this.proxy.deployBar(ByteArrayWrapper.make(barFile)).getContent();
  }

  public ProcessDefinition deploy(Deployment deployment) {
    return this.proxy.deploy(deployment).getContent();
  }

  public boolean undeploy(QName processQName) {
    return this.proxy.undeploy(processQName.getNamespaceURI(), processQName.getLocalPart());
  }

  public boolean undeploy(ProcessDefinitionUUID processDefinitionUUID) {
    return this.proxy.undeploy(processDefinitionUUID);
  }

  public boolean remove(ProcessDefinitionUUID processDefinitionUUID) {
    return this.proxy.remove(processDefinitionUUID);
  }

  public void initialize() {
    this.proxy.initialize();
  }

  public void deployWebServices(ProcessDefinitionUUID processDefinitionUUID) {
    this.proxy.deployWebServices(processDefinitionUUID);
  }

  public void undeployWebServices(ProcessDefinitionUUID processDefinitionUUID) {
    this.proxy.undeployWebServices(processDefinitionUUID);
  }

  public boolean retire(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
    return this.proxy.retire(processDefinitionUUID);
  }

  public boolean activate(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
    return this.proxy.activate(processDefinitionUUID);
  }

  public void refreshProcess(ProcessDefinitionUUID processDefinitionUUID) {
    this.proxy.refreshProcess(processDefinitionUUID);
  }

  public boolean isExtensionSupported(String namespace) {
    return this.proxy.isExtensionSupported(namespace);
  }
}
