/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.rest.client;

import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.ow2.orchestra.facade.QueryRuntimeAPI;
import org.ow2.orchestra.facade.criteria.Criteria;
import org.ow2.orchestra.facade.criteria.PagedResult;
import org.ow2.orchestra.facade.exception.ActivityInstanceNotFoundException;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.rest.JaxRSQueryRuntimeAPI;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.util.JAXBUtils;
import org.ow2.orchestra.util.Misc;

import java.util.Arrays;
import java.util.Set;

/**
 * @author Guillaume Porcher
 */
public class JaxRSQueryRuntimeAPIClient implements QueryRuntimeAPI {
  private final JaxRSQueryRuntimeAPI proxy;

  public JaxRSQueryRuntimeAPIClient(String orchestraURL) {
    JAXBElementProvider provider = new JAXBElementProvider();
    provider.setCollectionWrapperName("collection");
    provider.setSingleJaxbContext(true);
    provider.setExtraClass(JAXBUtils.JAXB_CLASSES);
    this.proxy = JAXRSClientFactory.create(orchestraURL, JaxRSQueryRuntimeAPI.class, Arrays.asList(provider));
  }

  public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID) throws InstanceNotFoundException {
    return this.proxy.findActivityInstances(processUUID, null).getContentAsSet();
  }

  public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID, ActivityState activityState) throws InstanceNotFoundException {
    return this.proxy.findActivityInstances(processUUID, activityState).getContentAsSet();
  }

  public Set<ProcessInstance> findProcessInstances() {
    try {
      return this.proxy.findProcessInstances(null, null).getContentAsSet();
    } catch (ProcessNotFoundException e) {
      Misc.unreachableStatement();
      return null;
    }
  }

  public PagedResult<ProcessInstance> findProcessInstancesPage(Criteria<ProcessInstance> criteria) {
    return this.proxy.findProcessInstancesPage(criteria);
  }

  public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
    return this.proxy.findProcessInstances(processDefinitionUUID, null).getContentAsSet();
  }

  public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) throws ProcessNotFoundException {
    return this.proxy.findProcessInstances(processDefinitionUUID, processInstanceState).getContentAsSet();
  }

  public Set<ProcessInstance> findProcessInstances(ActivityState processInstanceState) {
    try {
      return this.proxy.findProcessInstances(null, processInstanceState).getContentAsSet();
    } catch (ProcessNotFoundException e) {
      Misc.unreachableStatement();
      return null;
    }
  }

  public ProcessInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
    return this.proxy.getProcessInstance(processInstanceUUID).getContent();
  }

  public ActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) throws ActivityInstanceNotFoundException {
    return this.proxy.getActivityInstance(activityInstanceUUID).getContent();
  }
}
