/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.util.LinkedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.search.FiqlParseException;
import org.apache.cxf.jaxrs.ext.search.FiqlParser;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchContextImpl
implements SearchContext {
    public static final String SEARCH_QUERY = "_search";
    public static final String SHORT_SEARCH_QUERY = "_s";
    private Message message;

    public SearchContextImpl(Message message) {
        this.message = message;
    }

    @Override
    public <T> SearchCondition<T> getCondition(Class<T> cls) {
        FiqlParser<T> parser = this.getParser(cls);
        String expression = this.getSearchExpression();
        if (expression != null) {
            try {
                return parser.parse(expression);
            }
            catch (FiqlParseException ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getSearchExpression() {
        String queryStr = (String)this.message.get(Message.QUERY_STRING);
        if (queryStr != null && (queryStr.contains(SHORT_SEARCH_QUERY) || queryStr.contains(SEARCH_QUERY))) {
            MultivaluedMap<String, String> params = JAXRSUtils.getStructuredParams(queryStr, "&", true, false);
            if (params.containsKey(SHORT_SEARCH_QUERY)) {
                return params.getFirst(SHORT_SEARCH_QUERY);
            }
            return params.getFirst(SEARCH_QUERY);
        }
        return null;
    }

    private <T> FiqlParser<T> getParser(Class<T> cls) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(2);
        props.put("search.date-format", (String)this.message.getContextualProperty("search.date-format"));
        props.put("search.timezone.support", (String)this.message.getContextualProperty("search.timezone.support"));
        return new FiqlParser<T>(cls, props);
    }
}

